﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="System.Collections.Generic" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Pełna lista płac</title>
		<script runat="server">

    //Max długość opisu z numerami list płac. 0 oznacza bez limitu.
    static int maxOpisLen = 0;
    
    public class Params : ContextBase {
    
        public Params(Context cx) : base(cx) {
        }
    
        bool paski = false;
    
        [Caption("Osobne paski wypłat")]
        [Priority(2)]
        public bool Paski {
            get { return paski; }
            set { paski = value; }
        }
    
        bool sumy = false;
    
        [Caption("Suma dla pracownika")]
        [Priority(3)]
        public bool Sumy {
            get { return sumy; }
            set { sumy = value; }
        }

        bool sumujWyplaty = false;
        [Caption("Sumuj wypłaty")]
        [Priority(3)]
        public bool SumujWyplaty {
            get { return sumujWyplaty; }
            set {
                sumujWyplaty = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool IsReadOnlySumujWyplaty() {
            return sumujWyplatyWgMiesiac;
        }

        bool sumujWyplatyWgMiesiac = false;
        [Caption("Sumuj wg miesiąca")]
        [Priority(4)]
        public bool SumujWyplatyWgMiesiac {
            get { return sumujWyplatyWgMiesiac; }
            set {
                sumujWyplatyWgMiesiac = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool IsReadOnlySumujWyplatyWgMiesiac() {
            return sumujWyplaty;
        }
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //static bool fundusze = false;
        bool fundusze = false;
        [Priority(1)]
        [Caption("Fundusze")]
        public bool Fundusze {
            get { return fundusze; }
            set {
                fundusze = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //static bool hideOperator = false;
        bool hideOperator = false;
        [Priority(2)]
        [Caption("Ukryj operatora")]
        public bool HideOperator {
            get { return hideOperator; }
            set {
                hideOperator = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Na wydruku umieszczaj numer umowy
        //static bool tytulUmowy = false;
        bool tytulUmowy = false;
        [Priority(3)]
        [Caption("Numer umowy")]
        public bool TytulUmowy {
            get { return tytulUmowy; }
            set {
                tytulUmowy = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
		
    Currency brutto = 0;
    Currency wyplata = 0;
    Hashtable elements = new Hashtable();

    decimal sumaPod26 = 0;
    decimal sumaEmerPrac = 0;
    decimal sumaRentPrac = 0;
    decimal sumaChorPrac = 0;
    decimal sumaWypadPrac = 0;
    decimal sumaZdrowPrac = 0;
    decimal sumaEmerFirma = 0;
    decimal sumaRentFirma = 0;
    decimal sumaChorFirma = 0;
    decimal sumaWypadFirma = 0;
    decimal sumaZdrowFirma = 0;
    decimal sumaFP = 0;
    decimal sumaFGSP = 0;
    decimal sumaFEP = 0;
    decimal sumaPPKPodst = 0;
    decimal sumaPPKPrac = 0;
    decimal sumaPPKFirma = 0;
    decimal sumaZaliczka = 0;
    decimal sumaKoszty = 0;
    decimal sumaUlga = 0;
	decimal sumaUlgaKlasaSrednia = 0;
    decimal sumaVAT = 0;
    Currency sumaGotowka = 0;
    Currency sumaROR = 0;
    
    public class Elem : IComparable {
        int counter = 0;
        string name;
        decimal dodatki = 0;
        decimal potrącenia = 0;
    
        public Elem(DefinicjaElementu definicja) {
            this.name = definicja.Nazwa;
        }
    
        public void Add(decimal wartość) {
            ++counter;
            if (wartość>0)
                dodatki += wartość;
            else
                potrącenia -= wartość;
        }
    
        public int Counter { get { return counter; } }
        public string Name { get { return name; } }
        public decimal Dodatki { get { return dodatki; } }
        public decimal Potrącenia { get { return potrącenia; } }
        public decimal Razem { get { return dodatki-potrącenia; } }
    
        public int CompareTo(object v) {
            return string.Compare(Name, ((Elem)v).Name, true);
        }
    }
    
    class PitTotal {
        readonly string nazwa;
        decimal brutto;
        decimal zaliczka;
    
        public PitTotal(string nazwa) {
            this.nazwa = nazwa;
        }
        public void Add(WypElement element) {
            brutto += element.Wartosc;
            zaliczka += element.Podatki.ZalFIS;
        }
        public string Nazwa {
            get { return nazwa; }
        }
        public decimal Brutto {
            get { return brutto; }
        }
        public decimal Zaliczka {
            get { return zaliczka; }
        }
    }

    PitTotal[] pitTotal = new PitTotal[] { new PitTotal("PIT-4R"), new PitTotal("PIT-8AR"), new PitTotal("Inne") };

            class PodsumowanieVAT : IComparable<PodsumowanieVAT> {
                DefinicjaStawkiVat definicjaStawki;
                decimal netto, vat;
                public PodsumowanieVAT(DefinicjaStawkiVat definicjaStawki) {
                    this.definicjaStawki = definicjaStawki;
                }
                public void Add(WypElement element) {
                    if (element.Podatki.VAT.DefinicjaStawki != definicjaStawki)
                        throw new ArgumentException("Element z niezgodną definicją stawki VAT " + element + ".");
                    netto += element.Podatki.VAT.Podstawa;
                    vat += element.Podatki.VAT.Podatek;
                }
                public DefinicjaStawkiVat Stawka {
                    get { return definicjaStawki; }
                }

                public decimal Netto {
                    get { return netto; }
                }
                public decimal VAT {
                    get { return vat; }
                }
                public decimal Brutto {
                    get { return netto + vat; }
                }
                public int CompareTo(PodsumowanieVAT other) {
                    if (other == null)
                        return 1;
                    return definicjaStawki.Kod.CompareTo(other.definicjaStawki.Kod);
                }
            }

            Dictionary<DefinicjaStawkiVat, PodsumowanieVAT> podsumowanieVAT = new Dictionary<DefinicjaStawkiVat, PodsumowanieVAT>();
		    		    
    private void Grid_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        List<Wyplata> lw = (List<Wyplata>)args.Row;
        foreach (Wyplata wpp in lw)
            if (!(wpp is WyplataUmowa))
                throw new InvalidOperationException("Lista płac umów może być drukowana tylko dla wypłat umów. " + wpp);
        WyplataUmowa wp = (WyplataUmowa)lw[lw.Count - 1];        
    
		string nazimie = string.Format("<strong>{0}</strong><br>{1}", 
			wp.PracHistoria.Nazwisko,
			wp.PracHistoria.Imie);

        nazimie += "<br>";
            try {
                foreach (WyplataUmowa wpp in lw) {
			        nazimie += "<br>" + wpp.Umowa.Numer;
			        if (srpars.TytulUmowy)
				        nazimie += "<br>" + wpp.Umowa.Tytul;
		        }
            }
            catch{}
				
        colNazImie.EditValue = nazimie;
        colOkres.EditValue = wp.ListaPlac.Okres;
    
        decimal emerP = 0, rentP = 0, chorP = 0, wypadP = 0;
        decimal emerF = 0, rentF = 0, chorF = 0, wypadF = 0;
        decimal fis = 0, zdrow = 0, koszty = 0, ulga = 0, ulgaKlasaSrednia = 0, vat = 0;
        decimal sumaOpodat = 0, sumaNieOpodat = 0;
        decimal fp = 0, fgsp = 0, fep=0;
        decimal ppkp = 0, ppkf = 0;
        decimal p26 = 0;

		bool jestUlgaKś = false;
		
        Currency ror = Currency.Zero;
        Currency wartosc = Currency.Zero;
        foreach (Wyplata w in lw) {
            foreach (WypElement element in w.ElementyWgKolejności) {
                colElementy.AddLine(element.Nazwa);
                if (element.Definicja.Deklaracje.Zaliczka.Typ==TypZaliczkiPodatku.NieNaliczać) {
                    colNieOpodat.AddLine("{0:n}", element.Wartosc);
                    colOpodat.AddLine();
                    sumaNieOpodat += element.Wartosc;
                }
                else {
                    brutto += element.Wartosc;
                    colOpodat.AddLine("{0:n}", element.Wartosc);
                    colNieOpodat.AddLine();
                    sumaOpodat += element.Wartosc;
    
                       PozycjaPIT pozpit = element.Definicja.Deklaracje.PozycjaPIT;
                       if (pozpit!=null)
                           /*if (pozpit.PIT8A>0)
                               pitTotal[0].Add(element);
                           else if (pozpit.PIT8B>0)
                               pitTotal[1].Add(element);
                           else
                               pitTotal[2].Add(element);*/
                           if (pozpit.PIT8AR > 0 && element.Podatek)            //TID: 7342
                               pitTotal[1].Add(element);
                           else if (pozpit.PIT4R > 0 && element.ZaliczkaPodatku)
                               pitTotal[0].Add(element);
                           else
                               pitTotal[2].Add(element);
                }

                if (element.Podatki.VAT.DefinicjaStawki != null) {
                    PodsumowanieVAT ep;
                    if (!podsumowanieVAT.TryGetValue(element.Podatki.VAT.DefinicjaStawki, out ep))
                        podsumowanieVAT.Add(element.Podatki.VAT.DefinicjaStawki, ep = new PodsumowanieVAT(element.Podatki.VAT.DefinicjaStawki));
                    ep.Add(element);
                }                    
            
                emerP += element.Podatki.Emerytalna.Prac;
                rentP += element.Podatki.Rentowa.Prac;
                chorP += element.Podatki.Chorobowa.Prac;
                wypadP += element.Podatki.Wypadkowa.Prac;
    
                emerF += element.Podatki.Emerytalna.Firma;
                rentF += element.Podatki.Rentowa.Firma;
                chorF += element.Podatki.Chorobowa.Firma;
                wypadF += element.Podatki.Wypadkowa.Firma;
    
                fis += element.Podatki.ZalFIS;
                zdrow += element.Podatki.Zdrowotna.Prac;
                koszty += element.Podatki.KosztyPIT;
                ulga += element.Podatki.Ulga;
				ulgaKlasaSrednia += element.Podatki.UlgaKlasaSrednia;
                vat += element.Podatki.VAT.Podatek;

                fp += element.Podatki.FP.Skladka;
                fgsp += element.Podatki.FGSP.Skladka;
                fep += element.Podatki.FEP.Skladka;

                ppkp += element.Podatki.PPK.Pracownika;
                ppkf += element.Podatki.PPK.Pracodawcy;
    
                Elem elem = (Elem)elements[element.Definicja];
                if (elem==null) {
                    elem = new Elem(element.Definicja);
                    elements[element.Definicja] = elem;
                }
                elem.Add(element.Wartosc);
    
                sumaEmerPrac += element.Podatki.Emerytalna.Prac;
                sumaRentPrac += element.Podatki.Rentowa.Prac;
                sumaChorPrac += element.Podatki.Chorobowa.Prac;
                sumaWypadPrac += element.Podatki.Wypadkowa.Prac;
                sumaZdrowPrac += element.Podatki.Zdrowotna.Prac;
    
                sumaEmerFirma += element.Podatki.Emerytalna.Firma;
                sumaRentFirma += element.Podatki.Rentowa.Firma;
                sumaChorFirma += element.Podatki.Chorobowa.Firma;
                sumaWypadFirma += element.Podatki.Wypadkowa.Firma;
                sumaZdrowFirma += element.Podatki.Zdrowotna.Firma;
    
                sumaFP += element.Podatki.FP.Skladka;
                sumaFGSP += element.Podatki.FGSP.Skladka;
                sumaFEP += element.Podatki.FEP.Skladka;

                sumaPPKPodst += element.Podatki.PPK.Podstawa;
                sumaPPKPrac += element.Podatki.PPK.Pracownika;
                sumaPPKFirma += element.Podatki.PPK.Pracodawcy;
    
                sumaZaliczka += element.Podatki.ZalFIS;
                sumaKoszty += element.Podatki.KosztyPIT;
                sumaUlga += element.Podatki.Ulga;
				sumaUlgaKlasaSrednia += element.Podatki.UlgaKlasaSrednia;
                sumaVAT += element.Podatki.VAT.Podatek;
                p26 += element.Podatki.Przychod26;
                sumaPod26 += element.Podatki.Przychod26;
            }
            ror += w.Inne;
            wartosc += w.Wartosc;
			jestUlgaKś |= w.Data >= new Date(2022, 1, 1);
        }
        
        colNieOpodatSum.EditValue = sumaNieOpodat;
        colOpodatSum.EditValue = sumaOpodat;
        col26_03.EditValue =  p26;
    
        colZUS.AddLine("{0:n} E", emerP);
        colZUS.AddLine("{0:n} R", rentP);
        colZUS.AddLine("{0:n} C", chorP);
        if (wypadP!=0)
            colZUS.AddLine("{0:n} W", wypadP);
        colZUSSum.EditValue = emerP+rentP+chorP+wypadP;
    
        colZUSFirmy.AddLine("{0:n} E", emerF);
        colZUSFirmy.AddLine("{0:n} R", rentF);
        if (chorF!=0)
            colZUSFirmy.AddLine("{0:n} C", chorF);
        colZUSFirmy.AddLine("{0:n} W", wypadF);
        if (srpars.Fundusze) {
            colZUSFirmy.AddLine("{0:n} F", fp);
            colZUSFirmy.AddLine("{0:n} G", fgsp);
            colZUSFirmy.AddLine("{0:n} P", fep);
        }
        colZUSFirmySum.EditValue = emerF + rentF + chorF + wypadF + (srpars.Fundusze ? fp + fgsp + fep : 0m);
    
        colPodatki.AddLine("{0:n} US", fis);
        colPodatki.AddLine("{0:n} Z", zdrow);
        colPodatki.AddLine("{0:n} K", koszty);
        colPodatki.AddLine("{0:n} U", ulga);
		if(jestUlgaKś) colPodatki.AddLine("{0:n} UKś", ulgaKlasaSrednia);
        colPodatki.AddLine("{0:n} V", vat);
        colPodatkiSum.EditValue = fis+zdrow;

        colPPKPrac.EditValue = ppkp;
        colPPKFirmy.EditValue = ppkf;
        colPPKPracSum.EditValue = ppkp;
        colPPKFirmySum.EditValue = ppkf;

        colPodpis.AddLine(wartosc-ror);
        colPodpis.AddLine(ror);
        colPodpis.AddLine("");
        if (srpars.Fundusze && chorF!=0)
               colPodpis.AddLine("");
        colPodpis.AddLine("<center>.........................<br>(podpis)</center>");
    
        sumaGotowka += wartosc-ror;
        sumaROR += ror;
    
        wyplata += wartosc;
    }
    
    private void Grid_AfterRender(object sender, System.EventArgs e) {
        cellBrutto.EditValue = brutto;
        cellNetto.EditValue = wyplata;

        labelp26.EditValue = sumaPod26;
        labelEmerPrac.EditValue = sumaEmerPrac;
        labelRentPrac.EditValue = sumaRentPrac;
        labelChorPrac.EditValue = sumaChorPrac;
        labelWypadPrac.EditValue = sumaWypadPrac;
        labelZdrowPrac.EditValue = sumaZdrowPrac;
        labelEmerFirma.EditValue = sumaEmerFirma;
        labelRentFirma.EditValue = sumaRentFirma;
        labelChorFirma.EditValue = sumaChorFirma;
        labelWypadFirma.EditValue = sumaWypadFirma;
        labelZdrowFirma.EditValue = sumaZdrowFirma;
        labelFP.EditValue = sumaFP;
        labelFGSP.EditValue = sumaFGSP;
        labelFEP.EditValue = sumaFEP;
        labelZaliczka.EditValue = sumaZaliczka;
        labelKoszty.EditValue = sumaKoszty;
        labelUlga.EditValue = sumaUlga;
		labelUlgaKlasaSrednia.EditValue = sumaUlgaKlasaSrednia;
        labelVAT.EditValue = sumaVAT;
        labelGotowka.EditValue = sumaGotowka;
        labelROR.EditValue = sumaROR;

        labelPPKPrac.EditValue = sumaPPKPrac;
        labelPPKFirma.EditValue = sumaPPKFirma;
    
        labelPrac.EditValue = sumaEmerPrac + sumaRentPrac + sumaChorPrac + sumaWypadPrac;
        labelFirma.EditValue = sumaEmerFirma + sumaRentFirma + sumaChorFirma + sumaWypadFirma + sumaFP + sumaFGSP + sumaFEP;
    
        ArrayList arr = new ArrayList(elements.Values);
        arr.Sort();
        int i = 1;
        decimal _Counter = 0;
        decimal _Dodatki = 0;
        decimal _Potrącenia = 0;
        decimal _Razem = 0;
        Dictionary<int, object> listelem = new Dictionary<int, object>();
        foreach (Elem ev in arr)
        {
            _Counter += ev.Counter;
            _Dodatki += ev.Dodatki;
            _Potrącenia += ev.Potrącenia;
            _Razem += ev.Razem;
            listelem.Add(i++,ev);
        }

        DatalabelCounter.EditValue = _Counter;
        DatalabelDodatki.EditValue = _Dodatki;
        DatalabelPotrącenia.EditValue = _Potrącenia;
        DatalabelRazem.EditValue = _Razem;

        DataRepeaterZestawienieElementow.DataSource = listelem;
    
        ArrayList al = new ArrayList();
        foreach (PitTotal pt in pitTotal)
               if (pt.Brutto>0)
                   al.Add(pt);
        Grid3.DataSource = al;

        List<PodsumowanieVAT> lstvat = new List<PodsumowanieVAT>(podsumowanieVAT.Values);
        if (lstvat.Count == 0)
            SectionVat.Visible = false;
        else {
            SectionVat.Visible = true;
            lstvat.Sort();
            GridVat.DataSource = lstvat;
        }                    
    }

    bool sumujWyplaty = false;
    bool sumujWyplatyWgMiesiac = false;
    bool sumy = false;
    
    [Context(Required=true)]
    public Params Parametry {
        set {
            if (value.Paski)
                Grid.ShowHeader = ShowHeader.EveryRow;

            sumy = value.Sumy;

            if (!value.Sumy) {
                colOkres.Visible = false;
                colElementySum.Visible = false;
                colOpodatSum.Visible = false;
                colNieOpodatSum.Visible = false;
                colZUSSum.Visible = false;
                colZUSFirmySum.Visible = false;
                colPodatkiSum.Visible = false;
                colPodpis.RowSpan = 2;
                Grid.RowsInRow = 2;
            }

            sumujWyplaty = value.SumujWyplaty;
            sumujWyplatyWgMiesiac = value.SumujWyplatyWgMiesiac;
        }
    }

    class WyplataComparer : IComparer<Wyplata> {
        public int Compare(Wyplata x, Wyplata y) {
            int result = x.Pracownik.NazwiskoImię.CompareTo(y.Pracownik.NazwiskoImię);
            if (result == 0)
                result = x.Pracownik.Kod.CompareTo(y.Pracownik.Kod);
            return result;
        }
    }

          private bool JestPPK(ISessionable session, Date data) {
        YearMonth podlegaOd = PlaceModule.GetInstance(session).Config.PracowniczePlanyKapitałowe.Ogólne.PodlegaOd;
        return podlegaOd != YearMonth.Empty ? new FromTo(podlegaOd.FirstDay, Date.MaxValue).Contains(data) : false;
     }

    void dc_ContextLoad(Object sender, EventArgs e) {
        List<List<Wyplata>> wyplaty = new List<List<Wyplata>>();
        Row[] rows = (Row[])dc[typeof(Row[])];
        bool ppk = false; 
        bool bufor = false;
        string listy = "";
        List<Wyplata> lwp = new List<Wyplata>();
        foreach (ListaPlac lista in rows) {
            bufor |= lista.Bufor;

            if(!ppk)
                ppk = JestPPK(lista, lista.DataWyplaty);

            if (listy != "")
                listy += "; ";
            listy += "<b>" + lista.Numer.NumerPelny + "</b>";
            foreach (Wyplata wp in lista.Wyplaty)
                lwp.Add(wp);
        }
        lwp.Sort(new WyplataComparer());

        foreach (Wyplata wp in lwp) {
            if (!sumujWyplaty && !sumujWyplatyWgMiesiac) {
                List<Wyplata> lw = new List<Wyplata>();
                lw.Add(wp);
                wyplaty.Add(lw);
            }
            else {
                List<Wyplata> lw = null;
                foreach (List<Wyplata> l in wyplaty) {
                    foreach (Wyplata w in l) {
                        bool warunek = sumujWyplatyWgMiesiac ? w.ListaPlac.Okres == wp.ListaPlac.Okres : true;
                        if (w.Pracownik.Guid == wp.Pracownik.Guid &&
                            warunek && w.GetType() == wp.GetType()) {
                            lw = l;
                            break;
                        }
                    }
                    if (lw != null)
                        break;
                }
                if (lw == null) {
                    lw = new List<Wyplata>();
                    wyplaty.Add(lw);
                }
                lw.Add(wp);
            }
        }
				
        if (bufor)
            ReportHeader1["BUFOR"] = "Lista nie została zatwierdzona!|";
        else
            ReportHeader1["BUFOR"] = "";

        if (maxOpisLen!=0 && listy.Length>maxOpisLen)
            listy = listy.Substring(0, maxOpisLen-3) + "...";
            
        Opis.EditValue = "<font size=\"2\">Listy płac: " + listy + "</font>";
        Grid.DataSource = wyplaty;

        if(ppk)
            col26_04.ColSpan = 6;

        colPPKPrac.Visible = colPPKFirmy.Visible = sectionPPK.Visible = ppk;
        colPPKPracSum.Visible = colPPKFirmySum.Visible = ppk && sumy;
            
        if (srpars.HideOperator)
			stOperator.SubtitleType = SubtitleType.Empty;
    }

		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<font face="Tahoma">
			<form id="ŁączonaPełnaListaPłacUmów" method="post" runat="server">
				<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad" LeftMargin="-1" RightMargin="-1"></ea:datacontext>
				<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Lista płac|%BUFOR%</strong>Typ: <strong>{0}|</strong>Okres: <strong>{1}"
					runat="server" DataMember1="ListyPlacViewInfo+Params.Okres" DataMember0="ListyPlacViewInfo+Params.Typ"></cc1:reportheader>
				<ea:DataLabel id="Opis" runat="server" Bold="False"></ea:DataLabel>
				<ea:grid id="Grid" runat="server" RowTypeName="Soneta.Place.WyplataEtat, Soneta.KadryPlace"
					RowsInRow="3" onbeforerow="Grid_BeforeRow" onafterrender="Grid_AfterRender">
					<Columns>
						<ea:GridColumn Width="4" BottomBorder="Single" Align="Right" DataMember="#" Caption="Lp" ID="colLP"/>
                        <ea:GridColumn BottomBorder="Single" ID="col26_01" NoWrap="True"/>
						<ea:GridColumn BottomBorder="Single" ColSpan="2" Format="Za: {0}" ID="colOkres" NoWrap="True"/>					
                        <ea:GridColumn Width="26" BottomBorder="Single" Caption="Nazwisko i imię|Nr umowy" ID="colNazImie" VAlign="Top"/>
                        <ea:GridColumn BottomBorder="Single" ColSpan="2" Align="Center" ID="col26_02" Format="Przychód zw. art. 21 u.1 p.148 Suma: "/>	
						<ea:GridColumn Width="26" BottomBorder="Single" Caption="Elementy płacy" ID="colElementy" NoWrap="True" VAlign="Top"/>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="Suma:" ID="colElementySum"/>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="Elementy~opodatk." ID="colOpodat" VAlign="Top"/>
                        <ea:GridColumn Align="Right" BottomBorder="Single" ID="col26_03" Format="{0:n}"/>
                        <ea:GridColumn BottomBorder="Single" Align="Right" Format="{0:n}" ID="colOpodatSum"/>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="Elementy~nieopodatk." ID="colNieOpodat" VAlign="Top"/>
                        <ea:GridColumn BottomBorder="Single" ID="col26_04" ColSpan="4"/>
						<ea:GridColumn BottomBorder="Single" Align="Right" Format="{0:n}" ID="colNieOpodatSum"/>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="Składki ZUS~pracownika" ID="colZUS" VAlign="Top"/>
						<ea:GridColumn Align="Right" Format="{0:n}" ID="colZUSSum"/>
                        <ea:GridColumn BottomBorder="Single" Align="Right" Caption="Składki ZUS~pracodawcy" ID="colZUSFirmy" VAlign="Top"/>
						<ea:GridColumn Align="Right" Format="{0:n}" ID="colZUSFirmySum"/>
                        <ea:GridColumn BottomBorder="Single" Align="Right" Caption="Składki PPK~uczest" ID="colPPKPrac" VAlign="Top" Width="6"/>         
						<ea:GridColumn Align="Right" Format="{0:n}" ID="colPPKPracSum"/>
                        <ea:GridColumn BottomBorder="Single" Align="Right" Caption="Składki PPK~firma" ID="colPPKFirmy" VAlign="Top" Width="6"/>
						<ea:GridColumn Align="Right" Format="{0:n}" ID="colPPKFirmySum"/>						
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="Zal.US/Zdrow.|Koszty/Ulga|VAT" ID="colPodatki" VAlign="Top"/>
						<ea:GridColumn Align="Right" Format="{0:n} N" ID="colPodatkiSum"/>
						<ea:GridColumn Align="Right" Caption="Got&#243;wka|ROR" ID="colPodpis" RowSpan="3" VAlign="Top"/>
					</Columns>
				</ea:grid>
				<h6><font face="Tahoma" size="2">
						<ea:SectionMarker id="SectionMarker2" runat="server"></ea:SectionMarker>
						Podsumowanie:</font>
					<table id="Table4" style="FONT-SIZE: 8pt; FONT-FAMILY: Tahoma; BORDER-COLLAPSE: collapse"
						borderColor="silver" width="60%" border="1">
						<tbody>
							<tr>
								<td align="center" width="20%">Składka</td>
								<td align="center" width="20%">Składki pracownika</td>
								<td align="center" width="20%">Składki pracodawcy</td>
								<td align="center" width="20%"></td>
								<td align="center" width="20%"></td>
							</tr>
							<tr>
								<td>Emerytalna:</td>
								<td align="right"><ea:datalabel id="labelEmerPrac" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td align="right"><ea:datalabel id="labelEmerFirma" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td>Zaliczka podatku:</td>
								<td align="right"><ea:datalabel id="labelZaliczka" runat="server" Format="{0:n}"></ea:datalabel></td>
							</tr>
							<tr>
								<td>Rentowa:</td>
								<td align="right"><ea:datalabel id="labelRentPrac" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td align="right"><ea:datalabel id="labelRentFirma" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td>Koszty uzyskania:</td>
								<td align="right"><ea:datalabel id="labelKoszty" runat="server" Format="{0:n}"></ea:datalabel></td>
							</tr>
							<tr>
								<td style="HEIGHT: 16px">Chorobowa:</td>
								<td style="HEIGHT: 16px" align="right"><ea:datalabel id="labelChorPrac" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td style="HEIGHT: 16px" align="right"><ea:datalabel id="labelChorFirma" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td style="HEIGHT: 16px">Ulga podatkowa:</td>
								<td style="HEIGHT: 16px" align="right"><ea:datalabel id="labelUlga" runat="server" Format="{0:n}"></ea:datalabel></td>
							</tr>
							<TR>
								<td>Wypadkowa:</td>
								<td align="right"><ea:datalabel id="labelWypadPrac" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td align="right"><ea:datalabel id="labelWypadFirma" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td style="HEIGHT: 16px">Ulga klasa średnia:</td>
								<td style="HEIGHT: 16px" align="right"><ea:datalabel id="labelUlgaKlasaSrednia" runat="server" Format="{0:n}"></ea:datalabel></td>
							</TR>
							<tr>
								<td>FP:</td>
								<td></td>
								<td align="right"><ea:datalabel id="labelFP" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td>VAT:</td>
								<td align="right"><ea:datalabel id="labelVAT" runat="server" Format="{0:n}"></ea:datalabel></td>
							</tr>
							<tr>
								<td>FGŚP:</td>
								<td></td>
								<td align="right"><ea:datalabel id="labelFGSP" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td><strong>Gotówka:</strong></td>
								<td align="right"><ea:datalabel id="labelGotowka" runat="server" Format="{0:n}"></ea:datalabel></td>
							</tr>
							<tr>
								<td>FEP:</td>
								<td>&nbsp;</td>
								<td align="right">
		<font face="Tahoma">
			                        <ea:datalabel id="labelFEP" runat="server" Format="{0:n}"></ea:datalabel>
		</font>
		                        </td>
								<td><STRONG>ROR:</STRONG></td>
								<td align="right"><ea:datalabel id="labelROR" runat="server" Format="{0:n}"></ea:datalabel></td>
							</tr>
							<tr>
								<td><strong>Razem składki:</strong></td>
								<td align="right"><ea:datalabel id="labelPrac" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td align="right"><ea:datalabel id="labelFirma" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td></td>
								<td></td>
							</tr>
							<tr>
								<td>Zdrowotna:</td>
								<td align="right"><ea:datalabel id="labelZdrowPrac" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td align="right"><ea:datalabel id="labelZdrowFirma" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td></td>
								<td></td>
							</tr>
                            <ea:Section ID="sectionPPK" runat="server">
                            <tr>
								<td>PPK:</td>
								<td align="right"><ea:datalabel id="labelPPKPrac" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td align="right"><ea:datalabel id="labelPPKFirma" runat="server" Format="{0:n}"></ea:datalabel></td>
								<td></td>
								<td></td>
							</tr>
                            </ea:Section>
						</tbody>
					</table>
				</h6>
				<h6><font face="Tahoma" size="2">
						<ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
						Zestawienie elementów:</font>
					<br>
					<table style="FONT-SIZE: 8pt; font-weight:normal; FONT-FAMILY: Tahoma; BORDER-COLLAPSE: collapse" borderColor="silver" width="505" border="1">
					<tbody>
                         <tr>
							<td align="Center" Width="4">Lp</td>
                            <td align="Center" Width="40"><b>Nazwa</b></td>
                            <td align="Center" Width="10"><b>Liczba</b></td>
                            <td align="Center" Width="12"><b>Dodatki</b></td>
                            <td align="Center" Width="12"><b>Potrącenia</b></td>
                            <td align="Center" Width="12"><b>Razem</b></td>
						</tr>
                        <ea:DataRepeater id="DataRepeaterZestawienieElementow" WithSections="False" runat="server">
                         <tr>
							<td align="Center" Width="4"><ea:datalabel Bold="False" DataMember="Key" runat="server"></ea:datalabel></td>
                            <td align="Left"  Width="40"><ea:datalabel Bold="False" DataMember="Value.Name" runat="server"></ea:datalabel></td>
                            <td align="Right" Width="10"><ea:datalabel Bold="False" DataMember="Value.Counter" runat="server"></ea:datalabel></td>
                            <td align="Right" Width="12"><ea:datalabel Bold="False" DataMember="Value.Dodatki" runat="server" Format="{0:n}"></ea:datalabel></td>
                            <td align="Right" Width="12"><ea:datalabel Bold="False" DataMember="Value.Potrącenia" runat="server" Format="{0:n}"></ea:datalabel></td>
                            <td align="Right" Width="12"><ea:datalabel Bold="False" DataMember="Value.Razem" runat="server" Format="{0:n}"></ea:datalabel></td>
						</tr>
                        </ea:DataRepeater>
                        <tr>
                            <td align="Center" Width="4"></td>
							<td align="Center" Width="40"><b>Suma: </b></td>
							<td align="Right" width="10"><b><ea:datalabel id="DatalabelCounter" runat="server"></ea:datalabel></b></td>
                            <td align="Right" Width="12"><b><ea:datalabel id="DatalabelDodatki" runat="server" Format="{0:n}"></ea:datalabel></b></td>
                            <td align="Right" Width="12"><b><ea:datalabel id="DatalabelPotrącenia" runat="server" Format="{0:n}"></ea:datalabel></b></td>
                            <td align="Right" Width="12"><b><ea:datalabel id="DatalabelRazem" runat="server" Format="{0:n}"></ea:datalabel></b></td>
						</tr>
						<tr>
							<td align="Center"colspan="3"><b>Przychód zw. art. 21 u.1 p.148 Suma: </b></td>
							<td align="Right"><b><ea:datalabel  id="labelp26" runat="server" Format="{0:n}"></ea:datalabel></b></td>
                            <td align="Right"/>
                            <td align="Center"/>
						</tr>
                    </tbody>
                 </table>  
				</h6>
		</font>
		<h6>
			<ea:SectionMarker id="SectionMarker3" runat="server"></ea:SectionMarker>
			<font face="Tahoma" size="2">Zestawienie zaliczki podatku lub podatku wg deklaracji 
				PIT: </font>
			<br>
			<ea:Grid id="Grid3" runat="server">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp"></ea:GridColumn>
					<ea:GridColumn Width="35" DataMember="Nazwa" Total="Info" Caption="Deklaracja"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="Brutto" Total="Sum" Caption="Brutto" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="Zaliczka" Total="Sum" Caption="Zaliczka podatku lub podatek"
						Format="{0:n}"></ea:GridColumn>
				</Columns>
			</ea:Grid>
            <ea:Section ID="SectionVat" runat="server" Width="100%">
                <p>
                    &nbsp;<ea:SectionMarker ID="Sectionmarker5" runat="server">
                    </ea:SectionMarker>
                    <strong><font face="Tahoma" size="2">Zestawienie podatku VAT wg stawki</font> </strong>
                    <ea:Grid ID="GridVat" runat="server" WithSections="False">
                        <Columns>
                            <ea:GridColumn runat="server" Align="Right" Caption="Lp" DataMember="#" Width="4">
                            </ea:GridColumn>
                            <ea:GridColumn runat="server" Caption="Stawka" DataMember="Stawka" Total="Info" Width="35">
                            </ea:GridColumn>
                            <ea:GridColumn runat="server" Align="Right" Caption="Netto" DataMember="Netto" Format="{0:n}"
                                Total="Sum" Width="12">
                            </ea:GridColumn>
                            <ea:GridColumn runat="server" Align="Right" Caption="VAT" DataMember="VAT" Format="{0:n}"
                                Total="Sum" Width="12">
                            </ea:GridColumn>
                            <ea:GridColumn runat="server" Align="Right" Caption="Brutto" DataMember="Brutto"
                                Format="{0:n}" Total="Sum" Width="12">
                            </ea:GridColumn>
                        </Columns>
                    </ea:Grid>
                </p>
            </ea:Section>
			<font face="Tahoma">
				<ea:SectionMarker id="SectionMarker4" runat="server"></ea:SectionMarker>
				<cc1:reportfooter id="ReportFooter1" runat="server">
					<Cells>
						<cc1:FooterCell Caption="Opodatkowane (brutto):" Format1="{0:u}," ID="cellBrutto"></cc1:FooterCell>
						<cc1:FooterCell Caption="Do wypłaty (netto):" Format1="{0:u}," ID="cellNetto"></cc1:FooterCell>
					</Cells>
					<Subtitles>
						<cc1:FooterSubtitle Caption="Sprawdzono pod względem merytorycznym" SubtitleType="DataPodpis" Width="50"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Sprawdzono pod względem formalno prawnym" SubtitleType="DataPodpis" Width="50"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle ID="stOperator" SubtitleType="Operator"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="data"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="gł&#243;wny księgowy"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="kierownik jednostki"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:reportfooter>
			</font>
		</h6>
    	</form>
	</body>
</HTML>
